<div class="min-h-full bg-gray-50">
    @php
        $guard = 'staff';
        $user = $staff;
    @endphp

    @include('partials.dashboard-nav', [
        'subtitle' => 'Essay Grading',
        'userName' => $staff->full_name,
        'userRole' => $staff->roles->first()?->name ?? $terminology->secondary_user_singular,
        'logoutRoute' => route('staff.logout')
    ])

    <!-- Main Content -->
    <main class="py-8">
        <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <!-- Page Header -->
            <div class="mb-8 flex items-center justify-between">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">Essay Grading</h2>
                    <p class="mt-1 text-sm text-gray-600">Review and grade essay answers from candidates</p>
                </div>
                <a href="{{ route('staff.dashboard') }}" class="inline-flex items-center text-sm text-gray-600 hover:text-gray-900">
                    <svg class="w-4 h-4 mr-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 19.5L3 12m0 0l7.5-7.5M3 12h18" />
                    </svg>
                    Back to Dashboard
                </a>
            </div>

            {{-- Flash Messages --}}
            @if(session('success'))
                <div class="mb-6 bg-emerald-50 border border-emerald-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <svg class="h-5 w-5 text-emerald-600 mr-2" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <p class="text-sm text-emerald-800">{{ session('success') }}</p>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <svg class="h-5 w-5 text-red-600 mr-2" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m9-.75a9 9 0 11-18 0 9 9 0 0118 0zm-9 3.75h.008v.008H12v-.008z" />
                        </svg>
                        <p class="text-sm text-red-800">{{ session('error') }}</p>
                    </div>
                </div>
            @endif

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3 mb-8">
                <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 p-3 rounded-lg bg-amber-100">
                            <svg class="w-6 h-6 text-amber-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-500">Pending</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $pendingCount }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 p-3 rounded-lg bg-emerald-100">
                            <svg class="w-6 h-6 text-emerald-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-500">Graded</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $gradedCount }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 p-3 rounded-lg bg-blue-100">
                            <svg class="w-6 h-6 text-blue-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25a2.25 2.25 0 01-2.25-2.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-500">Total</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $pendingCount + $gradedCount }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Answer List -->
                <div class="lg:col-span-1">
                    <div class="bg-white shadow-sm rounded-lg border border-gray-200">
                        <div class="px-4 py-3 border-b border-gray-200">
                            <div class="flex space-x-2">
                                <button wire:click="setFilter('pending')" 
                                        class="px-3 py-1.5 text-sm font-medium rounded-md {{ $filterStatus === 'pending' ? 'bg-amber-100 text-amber-700' : 'text-gray-500 hover:bg-gray-100' }}">
                                    Pending ({{ $pendingCount }})
                                </button>
                                <button wire:click="setFilter('graded')" 
                                        class="px-3 py-1.5 text-sm font-medium rounded-md {{ $filterStatus === 'graded' ? 'bg-emerald-100 text-emerald-700' : 'text-gray-500 hover:bg-gray-100' }}">
                                    Graded ({{ $gradedCount }})
                                </button>
                            </div>
                        </div>

                        <div class="divide-y divide-gray-200 max-h-[600px] overflow-y-auto">
                            @forelse($answers as $answer)
                                <button wire:click="selectAnswer({{ $answer->id }})" 
                                        class="w-full text-left px-4 py-3 hover:bg-gray-50 transition-colors {{ $selectedAnswerId === $answer->id ? 'bg-blue-50 border-l-4 border-blue-500' : '' }}">
                                    <div class="flex items-start justify-between">
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm font-medium text-gray-900 truncate">
                                                {{ $answer->attempt->exam->title ?? 'Unknown Exam' }}
                                            </p>
                                            <p class="text-xs text-gray-500 truncate mt-1">
                                                {{ Str::limit($answer->question->question_text ?? '', 50) }}
                                            </p>
                                            <p class="text-xs text-gray-400 mt-1">
                                                {{ $answer->attempt->candidate->full_name ?? $answer->attempt->candidate->name ?? 'Unknown' }}
                                            </p>
                                        </div>
                                        <div class="ml-2 flex-shrink-0">
                                            @if($answer->is_graded)
                                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-emerald-100 text-emerald-800">
                                                    {{ $answer->marks_obtained }}/{{ $answer->marks_possible }}
                                                </span>
                                            @else
                                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-amber-100 text-amber-800">
                                                    Pending
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </button>
                            @empty
                                <div class="px-4 py-8 text-center text-gray-500">
                                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    <p class="mt-2 text-sm">No {{ $filterStatus }} essays found</p>
                                </div>
                            @endforelse
                        </div>

                        @if($answers->hasPages())
                            <div class="px-4 py-3 border-t border-gray-200">
                                {{ $answers->links() }}
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Grading Panel -->
                <div class="lg:col-span-2">
                    @if($currentAnswer)
                        <div class="bg-white shadow-sm rounded-lg border border-gray-200">
                            <!-- Header -->
                            <div class="px-6 py-4 border-b border-gray-200">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="text-lg font-medium text-gray-900">
                                            {{ $currentAnswer->attempt->exam->title ?? 'Exam' }}
                                        </h3>
                                        <p class="text-sm text-gray-500">
                                            Candidate: {{ $currentAnswer->attempt->candidate->full_name ?? $currentAnswer->attempt->candidate->name ?? 'Unknown' }}
                                        </p>
                                    </div>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                                        {{ $currentAnswer->marks_possible }} marks
                                    </span>
                                </div>
                            </div>

                            <!-- Question -->
                            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                                <h4 class="text-sm font-medium text-gray-700 mb-2">Question</h4>
                                <div class="text-gray-900 prose prose-sm max-w-none">
                                    {!! $currentAnswer->question->question_text ?? 'No question text' !!}
                                </div>
                            </div>

                            <!-- Candidate's Answer -->
                            <div class="px-6 py-4 border-b border-gray-200">
                                <h4 class="text-sm font-medium text-gray-700 mb-2">Candidate's Answer</h4>
                                <div class="p-4 bg-white border border-gray-200 rounded-lg prose prose-sm max-w-none">
                                    {!! nl2br(e($currentAnswer->essay_answer ?? 'No answer provided')) !!}
                                </div>
                                @if($currentAnswer->question->min_words || $currentAnswer->question->max_words)
                                    @php
                                        $wordCount = str_word_count($currentAnswer->essay_answer ?? '');
                                        $minWords = $currentAnswer->question->min_words ?? 0;
                                        $maxWords = $currentAnswer->question->max_words ?? PHP_INT_MAX;
                                        $isWithinRange = $wordCount >= $minWords && $wordCount <= $maxWords;
                                    @endphp
                                    <div class="mt-2 text-sm {{ $isWithinRange ? 'text-gray-500' : 'text-amber-600' }}">
                                        Word count: {{ $wordCount }} 
                                        @if($minWords > 0 && $maxWords < PHP_INT_MAX)
                                            (Required: {{ $minWords }}-{{ $maxWords }})
                                        @elseif($minWords > 0)
                                            (Minimum: {{ $minWords }})
                                        @elseif($maxWords < PHP_INT_MAX)
                                            (Maximum: {{ $maxWords }})
                                        @endif
                                    </div>
                                @endif
                            </div>

                            <!-- Grading Form -->
                            <div class="px-6 py-4">
                                <form wire:submit.prevent="submitGrade">
                                    <div class="grid grid-cols-1 gap-4">
                                        <div>
                                            <label for="marksAwarded" class="block text-sm font-medium text-gray-700">
                                                Marks Awarded
                                            </label>
                                            <div class="mt-1 flex items-center">
                                                <input type="number" 
                                                       wire:model="marksAwarded" 
                                                       id="marksAwarded"
                                                       min="0" 
                                                       max="{{ $currentAnswer->marks_possible }}"
                                                       step="0.5"
                                                       class="block w-32 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                                                <span class="ml-2 text-sm text-gray-500">/ {{ $currentAnswer->marks_possible }}</span>
                                            </div>
                                            @error('marksAwarded')
                                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                            @enderror
                                        </div>

                                        <div>
                                            <label for="feedback" class="block text-sm font-medium text-gray-700">
                                                Feedback (Optional)
                                            </label>
                                            <textarea wire:model="feedback" 
                                                      id="feedback"
                                                      rows="3"
                                                      class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                                      placeholder="Provide constructive feedback to the candidate..."></textarea>
                                            @error('feedback')
                                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="mt-6 flex items-center justify-end space-x-3">
                                        <button type="button" 
                                                wire:click="skipAnswer"
                                                class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">
                                            Skip
                                        </button>
                                        <button type="submit"
                                                class="px-4 py-2 bg-blue-600 text-white rounded-md text-sm font-medium hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                            Submit Grade
                                        </button>
                                    </div>
                                </form>
                            </div>

                            @if($currentAnswer->is_graded && $currentAnswer->grader)
                                <div class="px-6 py-3 bg-gray-50 border-t border-gray-200 rounded-b-lg">
                                    <p class="text-xs text-gray-500">
                                        Graded by {{ $currentAnswer->grader->full_name ?? 'Unknown' }} 
                                        on {{ $currentAnswer->graded_at?->format('M d, Y H:i') }}
                                    </p>
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-12 text-center">
                            <svg class="mx-auto h-16 w-16 text-gray-400" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z" />
                            </svg>
                            <h3 class="mt-4 text-lg font-medium text-gray-900">Select an Essay to Grade</h3>
                            <p class="mt-2 text-sm text-gray-500">
                                Click on an essay from the list on the left to start grading.
                            </p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </main>
</div>
