<div class="min-h-screen flex flex-col justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="sm:mx-auto sm:w-full sm:max-w-2xl">
        <!-- Header -->
        <div class="text-center mb-8">
            <div class="mx-auto h-16 w-16 flex items-center justify-center rounded-full bg-blue-100">
                <svg class="h-10 w-10 text-blue-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.325.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 0 1 1.37.49l1.296 2.247a1.125 1.125 0 0 1-.26 1.431l-1.003.827c-.293.241-.438.613-.43.992a7.723 7.723 0 0 1 0 .255c-.008.378.137.75.43.991l1.004.827c.424.35.534.955.26 1.43l-1.298 2.247a1.125 1.125 0 0 1-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.47 6.47 0 0 1-.22.128c-.331.183-.581.495-.644.869l-.213 1.281c-.09.543-.56.94-1.11.94h-2.594c-.55 0-1.019-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 0 1-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 0 1-1.369-.49l-1.297-2.247a1.125 1.125 0 0 1 .26-1.431l1.004-.827c.292-.24.437-.613.43-.991a6.932 6.932 0 0 1 0-.255c.007-.38-.138-.751-.43-.992l-1.004-.827a1.125 1.125 0 0 1-.26-1.43l1.297-2.247a1.125 1.125 0 0 1 1.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.086.22-.128.332-.183.582-.495.644-.869l.214-1.28Z" />
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                </svg>
            </div>
            <h2 class="mt-4 text-3xl font-bold tracking-tight text-gray-900">
                Setup Your CBT System
            </h2>
            <p class="mt-2 text-sm text-gray-600">
                Configure your Computer-Based Testing platform in just a few steps
            </p>
        </div>

        <!-- Progress Steps -->
        <nav aria-label="Progress" class="mb-8">
            <ol role="list" class="flex items-center justify-center">
                @foreach(['Organization', 'Branding', 'User Type', 'Terminology', 'Features', 'Admin'] as $index => $stepName)
                    @php $stepNumber = $index + 1; @endphp
                    <li class="relative {{ $index < 5 ? 'pr-8 sm:pr-20' : '' }}">
                        <div class="absolute inset-0 flex items-center" aria-hidden="true">
                            @if($index < 5)
                                <div class="h-0.5 w-full {{ $currentStep > $stepNumber ? 'bg-blue-600' : 'bg-gray-200' }}"></div>
                            @endif
                        </div>
                        <button 
                            wire:click="goToStep({{ $stepNumber }})"
                            @class([
                                'relative flex h-8 w-8 items-center justify-center rounded-full transition-colors',
                                'bg-blue-600 hover:bg-blue-700' => $currentStep > $stepNumber,
                                'border-2 border-blue-600 bg-white' => $currentStep === $stepNumber,
                                'border-2 border-gray-300 bg-white cursor-not-allowed' => $currentStep < $stepNumber,
                            ])
                            @disabled($currentStep < $stepNumber)
                        >
                            @if($currentStep > $stepNumber)
                                <svg class="h-5 w-5 text-white" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                </svg>
                            @else
                                <span @class([
                                    'text-sm font-medium',
                                    'text-blue-600' => $currentStep === $stepNumber,
                                    'text-gray-500' => $currentStep < $stepNumber,
                                ])>{{ $stepNumber }}</span>
                            @endif
                        </button>
                        <span class="absolute -bottom-6 left-1/2 -translate-x-1/2 whitespace-nowrap text-xs font-medium {{ $currentStep >= $stepNumber ? 'text-blue-600' : 'text-gray-500' }}">
                            {{ $stepName }}
                        </span>
                    </li>
                @endforeach
            </ol>
        </nav>

        <!-- Card Container -->
        <div class="mt-12 bg-white shadow-xl rounded-2xl overflow-hidden">
            <div class="px-6 py-8 sm:px-10">
                <!-- Step 1: Organization -->
                @if($currentStep === 1)
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Organization Information</h3>
                            <p class="mt-1 text-sm text-gray-500">Tell us about your organization</p>
                        </div>

                        <div class="space-y-4">
                            <div>
                                <label for="organizationName" class="block text-sm font-medium text-gray-700">
                                    Organization Name <span class="text-red-500">*</span>
                                </label>
                                <input 
                                    type="text" 
                                    id="organizationName"
                                    wire:model="organizationName"
                                    class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    placeholder="e.g., Federal University of Technology"
                                >
                                @error('organizationName') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="tagline" class="block text-sm font-medium text-gray-700">
                                    Tagline (Optional)
                                </label>
                                <input 
                                    type="text" 
                                    id="tagline"
                                    wire:model="tagline"
                                    class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    placeholder="e.g., Excellence in Education"
                                >
                            </div>

                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                <div>
                                    <label for="contactEmail" class="block text-sm font-medium text-gray-700">
                                        Contact Email
                                    </label>
                                    <input 
                                        type="email" 
                                        id="contactEmail"
                                        wire:model="contactEmail"
                                        class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="exams@university.edu"
                                    >
                                    @error('contactEmail') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                                </div>

                                <div>
                                    <label for="contactPhone" class="block text-sm font-medium text-gray-700">
                                        Contact Phone
                                    </label>
                                    <input 
                                        type="tel" 
                                        id="contactPhone"
                                        wire:model="contactPhone"
                                        class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="+234 800 000 0000"
                                    >
                                </div>
                            </div>

                            <div>
                                <label for="timezone" class="block text-sm font-medium text-gray-700">
                                    Timezone <span class="text-red-500">*</span>
                                </label>
                                <select 
                                    id="timezone"
                                    wire:model="timezone"
                                    class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                >
                                    @foreach($timezones as $tz => $label)
                                        <option value="{{ $tz }}">{{ $label }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Step 2: Branding -->
                @if($currentStep === 2)
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Branding & Colors</h3>
                            <p class="mt-1 text-sm text-gray-500">Customize the look and feel of your CBT system</p>
                        </div>

                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Organization Logo
                                </label>
                                <div class="flex items-center gap-4">
                                    @if($logo)
                                        <img src="{{ $logo->temporaryUrl() }}" class="h-16 w-16 object-contain rounded-lg border border-gray-200">
                                    @else
                                        <div class="h-16 w-16 flex items-center justify-center rounded-lg border-2 border-dashed border-gray-300">
                                            <svg class="h-8 w-8 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                    @endif
                                    <div>
                                        <input type="file" wire:model="logo" id="logo" class="hidden" accept="image/*">
                                        <label for="logo" class="cursor-pointer inline-flex items-center px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 transition-colors">
                                            <svg class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12" />
                                            </svg>
                                            Upload Logo
                                        </label>
                                        <p class="mt-1 text-xs text-gray-500">PNG, JPG up to 2MB</p>
                                    </div>
                                </div>
                                @error('logo') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                                <div>
                                    <label for="primaryColor" class="block text-sm font-medium text-gray-700">
                                        Primary Color
                                    </label>
                                    <div class="mt-1 flex items-center gap-2">
                                        <input 
                                            type="color" 
                                            id="primaryColor"
                                            wire:model.live="primaryColor"
                                            class="h-10 w-14 rounded border border-gray-300 cursor-pointer"
                                        >
                                        <input 
                                            type="text" 
                                            wire:model.live="primaryColor"
                                            class="flex-1 rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm"
                                            placeholder="#2563eb"
                                        >
                                    </div>
                                </div>

                                <div>
                                    <label for="secondaryColor" class="block text-sm font-medium text-gray-700">
                                        Secondary Color
                                    </label>
                                    <div class="mt-1 flex items-center gap-2">
                                        <input 
                                            type="color" 
                                            id="secondaryColor"
                                            wire:model.live="secondaryColor"
                                            class="h-10 w-14 rounded border border-gray-300 cursor-pointer"
                                        >
                                        <input 
                                            type="text" 
                                            wire:model.live="secondaryColor"
                                            class="flex-1 rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm"
                                        >
                                    </div>
                                </div>

                                <div>
                                    <label for="accentColor" class="block text-sm font-medium text-gray-700">
                                        Accent Color
                                    </label>
                                    <div class="mt-1 flex items-center gap-2">
                                        <input 
                                            type="color" 
                                            id="accentColor"
                                            wire:model.live="accentColor"
                                            class="h-10 w-14 rounded border border-gray-300 cursor-pointer"
                                        >
                                        <input 
                                            type="text" 
                                            wire:model.live="accentColor"
                                            class="flex-1 rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm"
                                        >
                                    </div>
                                </div>
                            </div>

                            <!-- Color Preview -->
                            <div class="mt-4 p-4 rounded-lg border border-gray-200">
                                <p class="text-sm font-medium text-gray-700 mb-3">Preview</p>
                                <div class="flex items-center gap-3">
                                    <button type="button" class="px-4 py-2 rounded-lg text-white text-sm font-medium" style="background-color: {{ $primaryColor }}">
                                        Primary Button
                                    </button>
                                    <button type="button" class="px-4 py-2 rounded-lg text-white text-sm font-medium" style="background-color: {{ $secondaryColor }}">
                                        Secondary
                                    </button>
                                    <button type="button" class="px-4 py-2 rounded-lg text-white text-sm font-medium" style="background-color: {{ $accentColor }}">
                                        Accent
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Step 3: User Type Preset -->
                @if($currentStep === 3)
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Organization Type</h3>
                            <p class="mt-1 text-sm text-gray-500">Select the type that best describes your organization</p>
                        </div>

                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            @foreach($presets as $key => $preset)
                                <label 
                                    class="relative flex cursor-pointer rounded-xl border p-4 transition-all {{ $selectedPreset === $key ? 'border-blue-500 bg-blue-50/20 ring-2 ring-blue-500' : 'border-gray-200 hover:border-gray-300' }}"
                                >
                                    <input 
                                        type="radio" 
                                        wire:model.live="selectedPreset" 
                                        value="{{ $key }}" 
                                        class="sr-only"
                                    >
                                    <div class="flex flex-col">
                                        <span class="block text-sm font-semibold text-gray-900">
                                            {{ $preset['label'] }}
                                        </span>
                                        <span class="mt-1 text-xs text-gray-500">
                                            {{ $preset['description'] }}
                                        </span>
                                        <span class="mt-2 text-xs text-gray-400">
                                            {{ $preset['primary']['singular'] }} / {{ $preset['secondary']['singular'] }}
                                        </span>
                                    </div>
                                    @if($selectedPreset === $key)
                                        <div class="absolute top-3 right-3">
                                            <svg class="h-5 w-5 text-blue-600" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                    @endif
                                </label>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Step 4: Terminology -->
                @if($currentStep === 4)
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Customize Terminology</h3>
                            <p class="mt-1 text-sm text-gray-500">Adjust the labels to match your organization's language</p>
                        </div>

                        <div class="space-y-6">
                            <!-- Primary Users -->
                            <div class="p-4 rounded-lg bg-gray-50/50">
                                <h4 class="text-sm font-medium text-gray-700 mb-3">Primary Users (Exam Takers)</h4>
                                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                                    <div>
                                        <label class="block text-xs font-medium text-gray-500">Singular</label>
                                        <input type="text" wire:model="primaryUserSingular" class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    </div>
                                    <div>
                                        <label class="block text-xs font-medium text-gray-500">Plural</label>
                                        <input type="text" wire:model="primaryUserPlural" class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    </div>
                                    <div>
                                        <label class="block text-xs font-medium text-gray-500">ID Label</label>
                                        <input type="text" wire:model="primaryUserIdLabel" class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    </div>
                                </div>
                            </div>

                            <!-- Secondary Users -->
                            <div class="p-4 rounded-lg bg-gray-50/50">
                                <h4 class="text-sm font-medium text-gray-700 mb-3">Secondary Users (Staff/Examiners)</h4>
                                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                                    <div>
                                        <label class="block text-xs font-medium text-gray-500">Singular</label>
                                        <input type="text" wire:model="secondaryUserSingular" class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    </div>
                                    <div>
                                        <label class="block text-xs font-medium text-gray-500">Plural</label>
                                        <input type="text" wire:model="secondaryUserPlural" class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    </div>
                                    <div>
                                        <label class="block text-xs font-medium text-gray-500">ID Label</label>
                                        <input type="text" wire:model="secondaryUserIdLabel" class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    </div>
                                </div>
                            </div>

                            <!-- Other Terminology -->
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Time Period Label</label>
                                    <input type="text" wire:model="periodLabel" class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" placeholder="e.g., Academic Session, Term">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Division Label</label>
                                    <input type="text" wire:model="divisionLabel" class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" placeholder="e.g., Department, Unit">
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Step 5: Features -->
                @if($currentStep === 5)
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Enable Features</h3>
                            <p class="mt-1 text-sm text-gray-500">Select the features you want to enable for your organization</p>
                        </div>

                        <div class="space-y-4">
                            <!-- Secondary User Exams -->
                            <label class="flex items-start gap-4 p-4 rounded-lg border border-gray-200 cursor-pointer hover:bg-gray-50/50 transition-colors">
                                <input type="checkbox" wire:model="featureSecondaryUserExams" class="mt-1 h-4 w-4 rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <div class="flex-1">
                                    <span class="block text-sm font-medium text-gray-900">{{ $secondaryUserSingular }} Exams</span>
                                    <span class="block text-xs text-gray-500 mt-1">Allow {{ strtolower($secondaryUserPlural) }} to take exams (e.g., promotional exams, assessments)</span>
                                </div>
                            </label>

                            <!-- Practice Mode -->
                            <label class="flex items-start gap-4 p-4 rounded-lg border border-gray-200 cursor-pointer hover:bg-gray-50/50 transition-colors">
                                <input type="checkbox" wire:model="featurePracticeMode" class="mt-1 h-4 w-4 rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <div class="flex-1">
                                    <span class="block text-sm font-medium text-gray-900">Practice Mode</span>
                                    <span class="block text-xs text-gray-500 mt-1">Allow users to take practice exams without affecting their official records</span>
                                </div>
                            </label>

                            <!-- Certificate Generation -->
                            <label class="flex items-start gap-4 p-4 rounded-lg border border-gray-200 cursor-pointer hover:bg-gray-50/50 transition-colors">
                                <input type="checkbox" wire:model="featureCertificateGeneration" class="mt-1 h-4 w-4 rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <div class="flex-1">
                                    <span class="block text-sm font-medium text-gray-900">Certificate Generation</span>
                                    <span class="block text-xs text-gray-500 mt-1">Automatically generate certificates for users who pass exams</span>
                                </div>
                            </label>

                            <!-- Result Printing -->
                            <label class="flex items-start gap-4 p-4 rounded-lg border border-gray-200 cursor-pointer hover:bg-gray-50/50 transition-colors">
                                <input type="checkbox" wire:model="featureResultPrinting" class="mt-1 h-4 w-4 rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <div class="flex-1">
                                    <span class="block text-sm font-medium text-gray-900">Result Printing</span>
                                    <span class="block text-xs text-gray-500 mt-1">Allow users to print their exam results</span>
                                </div>
                            </label>

                            <!-- Bulk Import -->
                            <label class="flex items-start gap-4 p-4 rounded-lg border border-gray-200 cursor-pointer hover:bg-gray-50/50 transition-colors">
                                <input type="checkbox" wire:model="featureBulkImport" class="mt-1 h-4 w-4 rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <div class="flex-1">
                                    <span class="block text-sm font-medium text-gray-900">Bulk Import</span>
                                    <span class="block text-xs text-gray-500 mt-1">Import questions and users from Excel/CSV files</span>
                                </div>
                            </label>

                            <!-- Dark Mode -->
                            <label class="flex items-start gap-4 p-4 rounded-lg border border-gray-200 cursor-pointer hover:bg-gray-50/50 transition-colors">
                                <input type="checkbox" wire:model="featureDarkMode" class="mt-1 h-4 w-4 rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <div class="flex-1">
                                    <span class="block text-sm font-medium text-gray-900">Dark Mode</span>
                                    <span class="block text-xs text-gray-500 mt-1">Allow users to switch to dark mode interface</span>
                                </div>
                            </label>
                        </div>
                    </div>
                @endif

                <!-- Step 6: Admin Account -->
                @if($currentStep === 6)
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Create Admin Account</h3>
                            <p class="mt-1 text-sm text-gray-500">Set up the Super Admin account to manage your CBT system</p>
                        </div>

                        <div class="space-y-4">
                            <div>
                                <label for="adminName" class="block text-sm font-medium text-gray-700">
                                    Full Name <span class="text-red-500">*</span>
                                </label>
                                <input 
                                    type="text" 
                                    id="adminName"
                                    wire:model="adminName"
                                    class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    placeholder="John Doe"
                                >
                                @error('adminName') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="adminEmail" class="block text-sm font-medium text-gray-700">
                                    Email Address <span class="text-red-500">*</span>
                                </label>
                                <input 
                                    type="email" 
                                    id="adminEmail"
                                    wire:model="adminEmail"
                                    class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    placeholder="admin@organization.com"
                                >
                                @error('adminEmail') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="adminPassword" class="block text-sm font-medium text-gray-700">
                                    Password <span class="text-red-500">*</span>
                                </label>
                                <input 
                                    type="password" 
                                    id="adminPassword"
                                    wire:model="adminPassword"
                                    class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    placeholder="••••••••"
                                >
                                <p class="mt-1 text-xs text-gray-500">Minimum 8 characters with uppercase, lowercase, and numbers</p>
                                @error('adminPassword') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="adminPasswordConfirmation" class="block text-sm font-medium text-gray-700">
                                    Confirm Password <span class="text-red-500">*</span>
                                </label>
                                <input 
                                    type="password" 
                                    id="adminPasswordConfirmation"
                                    wire:model="adminPasswordConfirmation"
                                    class="mt-1 block w-full px-4 py-3 text-base rounded-xl border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    placeholder="••••••••"
                                >
                                @error('adminPasswordConfirmation') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <!-- Summary -->
                        <div class="mt-6 p-4 rounded-lg bg-blue-50/20 border border-blue-200">
                            <h4 class="text-sm font-medium text-blue-800 mb-2">Setup Summary</h4>
                            <dl class="space-y-1 text-xs text-blue-700">
                                <div class="flex justify-between">
                                    <dt>Organization:</dt>
                                    <dd class="font-medium">{{ $organizationName }}</dd>
                                </div>
                                <div class="flex justify-between">
                                    <dt>Primary Users:</dt>
                                    <dd class="font-medium">{{ $primaryUserPlural }}</dd>
                                </div>
                                <div class="flex justify-between">
                                    <dt>Secondary Users:</dt>
                                    <dd class="font-medium">{{ $featureSecondaryUserExams ? $secondaryUserPlural : 'Disabled' }}</dd>
                                </div>
                            </dl>
                        </div>
                    </div>
                @endif
            </div>

            <!-- Navigation Footer -->
            <div class="px-6 py-4 bg-gray-50/50 border-t border-gray-200 flex justify-between">
                @if($currentStep > 1)
                    <button 
                        type="button"
                        wire:click="previousStep"
                        class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 hover:text-gray-900 transition-colors"
                    >
                        <svg class="h-5 w-5 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                        </svg>
                        Back
                    </button>
                @else
                    <div></div>
                @endif

                @if($currentStep < $totalSteps)
                    <button 
                        type="button"
                        wire:click="nextStep"
                        wire:loading.attr="disabled"
                        class="inline-flex items-center px-6 py-2 border border-transparent text-sm font-medium rounded-lg shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 disabled:opacity-50 transition-colors"
                    >
                        <span wire:loading.remove wire:target="nextStep">Continue</span>
                        <span wire:loading wire:target="nextStep">Processing...</span>
                        <svg wire:loading.remove wire:target="nextStep" class="h-5 w-5 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                        </svg>
                    </button>
                @else
                    <button 
                        type="button"
                        wire:click="completeSetup"
                        wire:loading.attr="disabled"
                        class="inline-flex items-center px-6 py-2 border border-transparent text-sm font-medium rounded-lg shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 disabled:opacity-50 transition-colors"
                    >
                        <span wire:loading.remove wire:target="completeSetup">Complete Setup</span>
                        <span wire:loading wire:target="completeSetup">Setting up...</span>
                        <svg wire:loading.remove wire:target="completeSetup" class="h-5 w-5 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                    </button>
                @endif
            </div>
        </div>

        <!-- Footer -->
        <p class="mt-8 text-center text-xs text-gray-500">
            CBT System &copy; {{ date('Y') }}. All rights reserved.
        </p>
    </div>
</div>
