<div class="min-h-full bg-gray-50">
    @php
        $guard = 'applicant';
        $user = $applicant;
        $applicantLabel = $terminology->applicant_user_singular ?? 'Applicant';
    @endphp

    @include('partials.dashboard-nav', [
        'subtitle' => $applicantLabel . ' Portal',
        'userName' => $applicant->full_name,
        'userRole' => $applicantLabel,
        'logoutRoute' => route('applicant.logout')
    ])

    <!-- Main Content -->
    <main class="py-8">
        <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <!-- Page Header -->
            <div class="mb-8">
                <h2 class="text-2xl font-bold text-gray-900">Welcome, {{ $applicant->full_name }}!</h2>
                <p class="mt-1 text-sm text-gray-600">
                    Application for: <span class="font-medium">{{ $applicant->position_applied }}</span>
                    @if($applicant->department)
                        · {{ $applicant->department }}
                    @endif
                </p>
            </div>

            {{-- In-Progress Exam Alert --}}
            @if($inProgressAttempt)
                <div class="mb-6 bg-amber-50 border border-amber-200 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <svg class="h-6 w-6 text-amber-600 animate-pulse" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m9-.75a9 9 0 11-18 0 9 9 0 0118 0zm-9 3.75h.008v.008H12v-.008z" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm font-medium text-amber-800">Assessment In Progress</h3>
                                <p class="text-sm text-amber-700 mt-1">
                                    You have an ongoing assessment: <strong>{{ $inProgressAttempt['exam_title'] }}</strong>
                                </p>
                            </div>
                        </div>
                        <a href="{{ route('applicant.exam.take', $inProgressAttempt['session_id']) }}" 
                           class="inline-flex items-center px-4 py-2 bg-amber-600 text-white text-sm font-medium rounded-lg hover:bg-amber-700 transition-colors">
                            <svg class="w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.348a1.125 1.125 0 010 1.971l-11.54 6.347a1.125 1.125 0 01-1.667-.985V5.653z" />
                            </svg>
                            Continue Assessment
                        </a>
                    </div>
                </div>
            @endif

            <!-- Quick Stats Grid -->
            <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-4 mb-8">
                <!-- Available Now -->
                <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 p-3 rounded-lg bg-emerald-100">
                            <svg class="w-6 h-6 text-emerald-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.348a1.125 1.125 0 010 1.971l-11.54 6.347a1.125 1.125 0 01-1.667-.985V5.653z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-500">Available Now</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $availableExamsCount }}</p>
                        </div>
                    </div>
                    @if($availableExamsCount > 0)
                        <a href="{{ route('applicant.exam.list') }}" class="mt-4 inline-flex items-center text-sm text-emerald-600 hover:text-emerald-700">
                            Take an assessment
                            <svg class="w-4 h-4 ml-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M13.5 4.5L21 12m0 0l-7.5 7.5M21 12H3" />
                            </svg>
                        </a>
                    @endif
                </div>

                <!-- Upcoming Assessments -->
                <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 p-3 rounded-lg bg-blue-100">
                            <svg class="w-6 h-6 text-blue-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 012.25-2.25h13.5A2.25 2.25 0 0121 7.5v11.25m-18 0A2.25 2.25 0 005.25 21h13.5a2.25 2.25 0 002.25-2.25m-18 0v-7.5A2.25 2.25 0 015.25 9h13.5a2.25 2.25 0 012.25 2.25v7.5" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-500">Upcoming</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $upcomingExamsCount }}</p>
                        </div>
                    </div>
                    <p class="mt-4 text-sm text-gray-500">Scheduled assessments</p>
                </div>

                <!-- Completed Assessments -->
                <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 p-3 rounded-lg bg-purple-100">
                            <svg class="w-6 h-6 text-purple-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-500">Completed</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $completedExamsCount }}</p>
                        </div>
                    </div>
                    <p class="mt-4 text-sm text-gray-500">Total assessments taken</p>
                </div>

                <!-- Application Status -->
                <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 p-3 rounded-lg bg-amber-100">
                            <svg class="w-6 h-6 text-amber-600" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h3.75M9 15h3.75M9 18h3.75m3-18v18a2.25 2.25 0 01-2.25 2.25H6.108c-1.135 0-2.098-.708-2.474-1.618a4.5 4.5 0 010-2.364C3.982 3.708 4.946 3 6.108 3h9.142a2.25 2.25 0 012.25 2.25z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-500">Status</p>
                            <p class="text-lg font-bold text-amber-600">In Progress</p>
                        </div>
                    </div>
                    <p class="mt-4 text-sm text-gray-500">Application #{{ $applicant->application_number }}</p>
                </div>
            </div>

            <!-- Main Content Grid -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Recent Results -->
                <div class="lg:col-span-2">
                    <div class="bg-white shadow-sm rounded-lg border border-gray-200">
                        <div class="px-6 py-4 border-b border-gray-200">
                            <h3 class="text-lg font-medium text-gray-900">
                                {{ $showResults ? 'Recent Assessment Results' : 'Recently Completed Assessments' }}
                            </h3>
                        </div>
                        @if(count($completedExams) > 0)
                            <div class="divide-y divide-gray-200">
                                @foreach($completedExams as $exam)
                                    <div wire:key="result-{{ $exam['id'] }}" class="px-6 py-4 flex items-center justify-between hover:bg-gray-50 transition-colors">
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm font-medium text-gray-900 truncate">{{ $exam['exam_title'] }}</p>
                                            <p class="text-xs text-gray-500">{{ $exam['exam_code'] }} · {{ \Carbon\Carbon::parse($exam['completed_at'])->diffForHumans() }}</p>
                                        </div>
                                        <div class="flex items-center space-x-4">
                                            @if($showResults)
                                                <div class="text-right">
                                                    <p class="text-lg font-bold {{ $exam['passed'] ? 'text-green-600' : 'text-red-600' }}">
                                                        {{ number_format($exam['score_percentage'], 1) }}%
                                                    </p>
                                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium {{ $exam['passed'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                        {{ $exam['passed'] ? 'PASSED' : 'FAILED' }}
                                                    </span>
                                                </div>
                                                <a href="{{ route('applicant.exam.result', $exam['id']) }}" class="text-emerald-600 hover:text-emerald-700">
                                                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" />
                                                    </svg>
                                                </a>
                                            @else
                                                <div class="text-right">
                                                    <span class="inline-flex items-center px-2.5 py-1 rounded text-xs font-medium bg-gray-100 text-gray-700">
                                                        <svg class="w-4 h-4 mr-1" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                        </svg>
                                                        Completed
                                                    </span>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="px-6 py-12 text-center">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h3.75M9 15h3.75M9 18h3.75m3-18v18a2.25 2.25 0 01-2.25 2.25H6.108c-1.135 0-2.098-.708-2.474-1.618a4.5 4.5 0 010-2.364C3.982 3.708 4.946 3 6.108 3h9.142a2.25 2.25 0 012.25 2.25z" />
                                </svg>
                                <h3 class="mt-4 text-sm font-medium text-gray-900">No assessments completed yet</h3>
                                <p class="mt-1 text-sm text-gray-500">Complete your first assessment to see your results here.</p>
                                @if($availableExamsCount > 0)
                                    <a href="{{ route('applicant.exam.list') }}" class="mt-4 inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-emerald-600 hover:bg-emerald-700">
                                        Browse Available Assessments
                                    </a>
                                @endif
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Quick Actions -->
                    <div class="bg-white shadow-sm rounded-lg border border-gray-200">
                        <div class="px-6 py-4 border-b border-gray-200">
                            <h3 class="text-lg font-medium text-gray-900">Quick Actions</h3>
                        </div>
                        <div class="px-6 py-4 space-y-3">
                            <a href="{{ route('applicant.exam.list') }}" 
                               class="w-full flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-emerald-600 hover:bg-emerald-700 transition-colors duration-200">
                                <svg class="w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.348a1.125 1.125 0 010 1.971l-11.54 6.347a1.125 1.125 0 01-1.667-.985V5.653z" />
                                </svg>
                                View Available Assessments
                            </a>
                        </div>
                    </div>

                    <!-- Upcoming Assessments -->
                    @if(count($upcomingExams) > 0)
                        <div class="bg-white shadow-sm rounded-lg border border-gray-200">
                            <div class="px-6 py-4 border-b border-gray-200">
                                <h3 class="text-lg font-medium text-gray-900">Upcoming Assessments</h3>
                            </div>
                            <div class="px-6 py-4 space-y-4">
                                @foreach($upcomingExams as $exam)
                                    <div wire:key="upcoming-{{ $exam['id'] }}" class="flex items-start space-x-3 p-3 bg-blue-50 rounded-lg border border-blue-100">
                                        <div class="flex-shrink-0">
                                            <svg class="w-5 h-5 text-blue-600 mt-0.5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm font-medium text-gray-900 truncate">{{ $exam['title'] }}</p>
                                            <p class="text-xs text-gray-500">{{ $exam['code'] }}</p>
                                            <p class="text-xs text-blue-600 mt-1">
                                                {{ \Carbon\Carbon::parse($exam['start_time'])->format('M d, Y \a\t h:i A') }}
                                            </p>
                                            <p class="text-xs text-gray-500">
                                                {{ $exam['duration'] }} mins · {{ $exam['total_questions'] }} questions
                                            </p>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <!-- Applicant Info -->
                    <div class="bg-gradient-to-br from-emerald-50 to-teal-50 border border-emerald-200 rounded-lg p-6">
                        <div class="flex items-center space-x-4">
                            <div class="flex-shrink-0">
                                <div class="w-12 h-12 bg-emerald-600 rounded-full flex items-center justify-center text-white text-lg font-bold">
                                    {{ strtoupper(substr($applicant->full_name, 0, 1)) }}
                                </div>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ $applicant->full_name }}</p>
                                <p class="text-xs text-gray-500">{{ $applicant->application_number }}</p>
                                <p class="text-xs text-gray-500">{{ $applicant->position_applied }}</p>
                                @if($applicant->department)
                                    <p class="text-xs text-gray-500">{{ $applicant->department }}</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
