@php
use App\Settings\OrganizationSettings;
use App\Settings\TerminologySettings;
use App\Settings\BrandingSettings;

$orgSettings = app(OrganizationSettings::class);
$termSettings = app(TerminologySettings::class);
$brandingSettings = app(BrandingSettings::class);

$orgName = $orgSettings->name ?? 'CBT System';
$tagline = $orgSettings->tagline;
$primaryUserLabel = $termSettings->primary_user_singular ?? 'Student';
$primaryUserIdLabel = $termSettings->primary_user_id_label ?? 'ID Number';
$secondaryUserLabel = $termSettings->secondary_user_singular ?? 'Staff';
$secondaryUserIdLabel = $termSettings->secondary_user_id_label ?? 'Staff Number';
$applicantLabel = $termSettings->applicant_user_singular ?? 'Applicant';
$applicantIdLabel = $termSettings->applicant_id_label ?? 'Application Number';
$primaryColor = $brandingSettings->primary_color ?? '#2563eb';
$authBackgroundUrl = $brandingSettings->getAuthBackgroundUrl();
@endphp

<div class="min-h-screen flex items-center justify-center py-6 px-4 sm:px-6 lg:px-8 relative">
    <!-- Background Image with Overlay -->
    <div class="absolute inset-0 z-0">
        <img 
            src="{{ $authBackgroundUrl }}" 
            alt="Background" 
            class="w-full h-full object-cover"
        />
        <div class="absolute inset-0 bg-gradient-to-br from-blue-900/70 via-blue-800/60 to-purple-900/70"></div>
    </div>

    <!-- Content -->
    <div class="max-w-md w-full relative z-10">
        <!-- Login Form with Integrated Header -->
        <form wire:submit="login" class="space-y-5 bg-white/95 backdrop-blur-sm p-6 sm:p-8 rounded-2xl shadow-2xl">
            <!-- Compact Header inside form -->
            <div class="text-center pb-4 border-b border-gray-200">
                <div class="flex items-center justify-center gap-3 mb-2">
                    <div class="bg-gray-100 rounded-xl p-2">
                        <x-app-logo size="md" />
                    </div>
                    <div class="text-left">
                        <h2 class="text-xl font-bold text-gray-900">{{ $orgName }}</h2>
                        <p class="text-xs text-gray-500">CBT Examination Portal</p>
                    </div>
                </div>
                @if($tagline)
                    <p class="text-sm text-gray-600 mt-1">{{ $tagline }}</p>
                @endif
            </div>
            <!-- User Type Selection -->
            <div>
                <label class="text-sm font-medium text-gray-700">I am a</label>
                <div class="mt-2 grid grid-cols-3 gap-3">
                    <button 
                        type="button"
                        wire:click="$set('user_type', 'student')"
                        class="relative flex flex-col items-center justify-center px-3 py-3 text-xs font-medium rounded-xl border-2 transition-all duration-200"
                        style="{{ $user_type === 'student' ? 'border-color: ' . $primaryColor . '; background-color: ' . $primaryColor . '10; color: ' . $primaryColor . ';' : '' }}"
                        @class([
                            'border-gray-200 bg-white text-gray-700 hover:border-gray-300' => $user_type !== 'student',
                        ])
                    >
                        <svg class="h-5 w-5 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l9-5-9-5-9 5 9 5z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"/>
                        </svg>
                        {{ $primaryUserLabel }}
                        @if($user_type === 'student')
                            <svg class="absolute top-1 right-1 h-4 w-4" style="color: {{ $primaryColor }}" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                        @endif
                    </button>
                    
                    <button 
                        type="button"
                        wire:click="$set('user_type', 'staff')"
                        class="relative flex flex-col items-center justify-center px-3 py-3 text-xs font-medium rounded-xl border-2 transition-all duration-200"
                        style="{{ $user_type === 'staff' ? 'border-color: ' . $primaryColor . '; background-color: ' . $primaryColor . '10; color: ' . $primaryColor . ';' : '' }}"
                        @class([
                            'border-gray-200 bg-white text-gray-700 hover:border-gray-300' => $user_type !== 'staff',
                        ])
                    >
                        <svg class="h-5 w-5 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                        {{ $secondaryUserLabel }}
                        @if($user_type === 'staff')
                            <svg class="absolute top-1 right-1 h-4 w-4" style="color: {{ $primaryColor }}" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                        @endif
                    </button>
                    
                    <button 
                        type="button"
                        wire:click="$set('user_type', 'applicant')"
                        class="relative flex flex-col items-center justify-center px-3 py-3 text-xs font-medium rounded-xl border-2 transition-all duration-200"
                        style="{{ $user_type === 'applicant' ? 'border-color: ' . $primaryColor . '; background-color: ' . $primaryColor . '10; color: ' . $primaryColor . ';' : '' }}"
                        @class([
                            'border-gray-200 bg-white text-gray-700 hover:border-gray-300' => $user_type !== 'applicant',
                        ])
                    >
                        <svg class="h-5 w-5 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        {{ $applicantLabel }}
                        @if($user_type === 'applicant')
                            <svg class="absolute top-1 right-1 h-4 w-4" style="color: {{ $primaryColor }}" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                        @endif
                    </button>
                </div>
                @error('user_type')
                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Identifier Field -->
            <div>
                <label for="identifier" class="block text-sm font-medium text-gray-700 mb-2">
                    @if($user_type === 'student')
                        {{ $primaryUserIdLabel }}
                    @elseif($user_type === 'applicant')
                        {{ $applicantIdLabel }}
                    @else
                        {{ $secondaryUserIdLabel }}
                    @endif
                </label>
                <input 
                    type="text" 
                    id="identifier"
                    wire:model.blur="identifier"
                    class="block w-full px-4 py-3 text-base border border-gray-300 rounded-xl shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 bg-white text-gray-900"
                    style="--tw-ring-color: {{ $primaryColor }}"
                    placeholder="@if($user_type === 'student') Enter your {{ strtolower($primaryUserIdLabel) }} @elseif($user_type === 'applicant') Enter your {{ strtolower($applicantIdLabel) }} @else Enter your {{ strtolower($secondaryUserIdLabel) }} @endif"
                    autocomplete="username"
                    @error('identifier') aria-invalid="true" aria-describedby="identifier-error" @enderror
                />
                @error('identifier')
                    <p id="identifier-error" class="mt-2 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Password Field -->
            <div>
                <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                    Password
                </label>
                <input 
                    type="password" 
                    id="password"
                    wire:model.blur="password"
                    class="block w-full px-4 py-3 text-base border border-gray-300 rounded-xl shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 bg-white text-gray-900"
                    style="--tw-ring-color: {{ $primaryColor }}"
                    placeholder="Enter your password"
                    autocomplete="current-password"
                    @error('password') aria-invalid="true" aria-describedby="password-error" @enderror
                />
                @error('password')
                    <p id="password-error" class="mt-2 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Submit Button -->
            <button 
                type="submit" 
                wire:loading.attr="disabled"
                wire:target="login"
                class="group relative w-full flex justify-center py-3 px-4 border border-transparent text-base font-medium rounded-xl text-white focus:outline-none focus:ring-2 focus:ring-offset-2 disabled:opacity-50 disabled:cursor-not-allowed transition-all duration-200 shadow-lg hover:shadow-xl"
                style="background-color: {{ $primaryColor }}; --tw-ring-color: {{ $primaryColor }}"
            >
                <!-- Loading Spinner -->
                <div wire:loading wire:target="login" class="absolute left-0 inset-y-0 flex items-center pl-4">
                    <svg class="h-5 w-5 text-white animate-spin" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                
                <!-- Button Text -->
                <span wire:loading.remove wire:target="login">
                    Sign In
                </span>
                <span wire:loading wire:target="login">
                    Authenticating...
                </span>
            </button>
            
            <!-- Footer inside form -->
            <p class="text-xs text-gray-400 text-center pt-4 border-t border-gray-100">
                {{ $orgName }} • Secure Access Portal
            </p>
        </form>
    </div>
</div>
