<x-filament-panels::page>
    <div class="space-y-6">
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-4">
                Bulk Student Upload
            </h3>
            
            <div class="prose max-w-none mb-6">
                <p class="text-sm text-gray-600">
                    Upload a CSV or Excel file to add multiple students at once. The file should contain the following columns:
                </p>
                <ul class="text-sm text-gray-600 mt-2">
                    <li><strong>full_name</strong> - Student's full name (required)</li>
                    <li><strong>email</strong> - Student's email address (required, must be unique)</li>
                    <li><strong>matriculation_number</strong> - Student ID/Matriculation number (required, must be unique)</li>
                    <li><strong>session</strong> - Academic session (optional, e.g., 2024/2025)</li>
                    <li><strong>password</strong> - Password (optional, defaults to matriculation number)</li>
                </ul>
            </div>

            <form wire:submit.prevent="upload" class="space-y-4">
                <div>
                    <label for="file" class="block text-sm font-medium text-gray-700 mb-2">
                        Select File
                    </label>
                    <input 
                        type="file" 
                        id="file" 
                        wire:model="file"
                        accept=".csv,.xlsx,.xls"
                        class="block w-full text-sm text-gray-500
                               file:mr-4 file:py-2 file:px-4
                               file:rounded-lg file:border-0
                               file:text-sm file:font-medium
                               file:bg-blue-50 file:text-blue-700
                               hover:file:bg-blue-100"
                    >
                    @error('file')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex gap-4">
                    <button 
                        type="submit" 
                        class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 disabled:opacity-50"
                        wire:loading.attr="disabled"
                    >
                        <span wire:loading.remove>Upload Students</span>
                        <span wire:loading>Processing...</span>
                    </button>
                    
                    <a 
                        href="{{ route('filament.admin.resources.students.index') }}"
                        class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                    >
                        Cancel
                    </a>
                </div>
            </form>
        </div>

        <div class="bg-blue-50/20 rounded-lg p-4">
            <h4 class="text-sm font-medium text-blue-800 mb-2">Sample CSV Format:</h4>
            <pre class="text-xs text-blue-700 bg-blue-100/40 p-3 rounded overflow-x-auto">full_name,email,matriculation_number,session,password
John Doe,john.doe@example.com,2024/MED/001,2024/2025,
Jane Smith,jane.smith@example.com,2024/MED/002,2024/2025,secret123</pre>
        </div>
    </div>
</x-filament-panels::page>
