<x-filament-panels::page>
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        {{-- Stats Cards --}}
        <div class="lg:col-span-3">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                    <div class="flex items-center gap-4">
                        <div class="p-3 bg-amber-100 dark:bg-amber-900/50 rounded-lg">
                            <x-heroicon-o-clock class="h-6 w-6 text-amber-600 dark:text-amber-400" />
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Pending Grading</p>
                            <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $pendingCount }}</p>
                        </div>
                    </div>
                </div>
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 p-6">
                    <div class="flex items-center gap-4">
                        <div class="p-3 bg-emerald-100 dark:bg-emerald-900/50 rounded-lg">
                            <x-heroicon-o-check-circle class="h-6 w-6 text-emerald-600 dark:text-emerald-400" />
                        </div>
                        <div>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Graded Today</p>
                            <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $gradedCount }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Pending Answers List --}}
        <div class="lg:col-span-1">
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700">
                <div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="font-semibold text-gray-900 dark:text-white">Pending Essays</h3>
                </div>
                <div class="divide-y divide-gray-200 dark:divide-gray-700 max-h-[600px] overflow-y-auto">
                    @forelse($pendingAnswers as $answer)
                        <button 
                            wire:click="selectAnswer({{ $answer['id'] }})"
                            class="w-full text-left px-4 py-3 hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors {{ $selectedAnswerId === $answer['id'] ? 'bg-primary-50 dark:bg-primary-900/20 border-l-4 border-primary-500' : '' }}"
                        >
                            <div class="flex justify-between items-start">
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium text-gray-900 dark:text-white truncate">
                                        {{ $answer['exam_title'] }}
                                    </p>
                                    <p class="text-xs text-gray-500 dark:text-gray-400 truncate">
                                        {{ $answer['question_preview'] }}
                                    </p>
                                    <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">
                                        {{ $answer['candidate_name'] }} • {{ $answer['submitted_at'] }}
                                    </p>
                                </div>
                                <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-200">
                                    {{ $answer['marks_possible'] }} pts
                                </span>
                            </div>
                        </button>
                    @empty
                        <div class="px-4 py-8 text-center text-gray-500 dark:text-gray-400">
                            <x-heroicon-o-check-badge class="h-12 w-12 mx-auto text-gray-300 dark:text-gray-600 mb-3" />
                            <p>All essays have been graded!</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

        {{-- Grading Panel --}}
        <div class="lg:col-span-2">
            @if($currentAnswer)
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700">
                    {{-- Answer Header --}}
                    <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                        <div class="flex items-start justify-between">
                            <div>
                                <h3 class="font-semibold text-gray-900 dark:text-white">
                                    {{ $currentAnswer->attempt->exam->title ?? 'Exam' }}
                                </h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400">
                                    Candidate: {{ $currentAnswer->attempt->candidate->full_name ?? $currentAnswer->attempt->candidate->name ?? 'Unknown' }}
                                </p>
                            </div>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-amber-100 dark:bg-amber-900/50 text-amber-800 dark:text-amber-200">
                                {{ $currentAnswer->marks_possible }} marks
                            </span>
                        </div>
                    </div>

                    {{-- Question --}}
                    <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-900/50">
                        <h4 class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider mb-2">Question</h4>
                        <p class="text-gray-900 dark:text-white">{{ $currentAnswer->question->question_text ?? 'N/A' }}</p>
                        
                        @if($currentAnswer->question->min_words || $currentAnswer->question->max_words)
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">
                                Word requirement: 
                                @if($currentAnswer->question->min_words && $currentAnswer->question->max_words)
                                    {{ $currentAnswer->question->min_words }} - {{ $currentAnswer->question->max_words }} words
                                @elseif($currentAnswer->question->min_words)
                                    Minimum {{ $currentAnswer->question->min_words }} words
                                @else
                                    Maximum {{ $currentAnswer->question->max_words }} words
                                @endif
                            </p>
                        @endif
                    </div>

                    {{-- Candidate's Answer --}}
                    <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                        <div class="flex items-center justify-between mb-2">
                            <h4 class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Candidate's Answer</h4>
                            @php
                                $wordCount = $currentAnswer->essay_answer ? str_word_count($currentAnswer->essay_answer) : 0;
                            @endphp
                            <span class="text-xs text-gray-500 dark:text-gray-400">{{ $wordCount }} words</span>
                        </div>
                        <div class="p-4 bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-lg max-h-64 overflow-y-auto">
                            <p class="text-gray-900 dark:text-white whitespace-pre-wrap">{{ $currentAnswer->essay_answer ?? 'No answer provided' }}</p>
                        </div>
                    </div>

                    {{-- Grading Form --}}
                    <div class="px-6 py-4">
                        <h4 class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider mb-4">Grade This Answer</h4>
                        
                        <form wire:submit="submitGrade">
                            {{ $this->form }}

                            <div class="flex items-center justify-end gap-3 mt-6">
                                <x-filament::button
                                    type="button"
                                    color="gray"
                                    wire:click="skipAnswer"
                                >
                                    Skip
                                </x-filament::button>
                                <x-filament::button
                                    type="submit"
                                    color="success"
                                >
                                    Submit Grade
                                </x-filament::button>
                            </div>
                        </form>
                    </div>
                </div>
            @else
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 p-12 text-center">
                    <x-heroicon-o-document-text class="h-16 w-16 mx-auto text-gray-300 dark:text-gray-600 mb-4" />
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-2">Select an Essay to Grade</h3>
                    <p class="text-gray-500 dark:text-gray-400">Choose an essay from the pending list to begin grading.</p>
                </div>
            @endif
        </div>
    </div>
</x-filament-panels::page>
