@php
    $branding = app(\App\Settings\BrandingSettings::class);
    $organization = app(\App\Settings\OrganizationSettings::class);
    $appName = $organization->name ?? config('app.name', 'CBT System');
    $faviconUrl = $branding->getFaviconUrl() ?? $branding->getLogoUrl();
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $title ?? 'Exam Portal' }} - {{ $appName }}</title>

    @if($faviconUrl)
        <link rel="icon" href="{{ $faviconUrl }}" type="image/x-icon">
        <link rel="shortcut icon" href="{{ $faviconUrl }}" type="image/x-icon">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="h-full bg-gray-100 font-sans antialiased">
    <div class="min-h-full">
        <!-- Navigation -->
        <nav class="bg-white shadow-sm border-b border-gray-200">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
                <div class="flex h-16 justify-between items-center">
                    <!-- Logo and Title -->
                    <div class="flex items-center space-x-4">
                        <x-app-logo size="sm" />
                        <div>
                            <h1 class="text-lg font-semibold text-gray-900">{{ $appName }}</h1>
                            <p class="text-sm text-gray-500">Examination Portal</p>
                        </div>
                    </div>

                    <!-- User Info -->
                    <div class="flex items-center space-x-4">
                        @if(isset($showTimer) && $showTimer)
                            <div id="exam-timer" class="flex items-center px-4 py-2 bg-gray-900 text-white rounded-lg font-mono text-lg">
                                <svg class="w-5 h-5 mr-2" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span id="timer-display">{{ $timerDisplay ?? '00:00' }}</span>
                            </div>
                        @endif
                        
                        <div class="text-right">
                            <p class="text-sm font-medium text-gray-900">{{ $userName ?? 'Candidate' }}</p>
                            <p class="text-xs text-gray-500">{{ $userRole ?? 'Exam Candidate' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="py-6">
            {{ $slot }}
        </main>
    </div>
    
    @if(isset($showTimer) && $showTimer)
    <script>
        let timeRemaining = {{ $timeRemaining ?? 0 }};
        
        function updateTimer() {
            const minutes = Math.floor(timeRemaining / 60);
            const seconds = timeRemaining % 60;
            document.getElementById('timer-display').textContent = 
                String(minutes).padStart(2, '0') + ':' + String(seconds).padStart(2, '0');
            
            if (timeRemaining <= 300) { // 5 minutes warning
                document.getElementById('exam-timer').classList.add('bg-red-600');
                document.getElementById('exam-timer').classList.remove('bg-gray-900');
            }
            
            if (timeRemaining <= 0) {
                Livewire.dispatch('timeExpired');
                clearInterval(timerInterval);
            }
            timeRemaining--;
        }
        
        const timerInterval = setInterval(updateTimer, 1000);
        updateTimer();
    </script>
    @endif
</body>
</html>
