@props(['title' => null])

@php
use App\Settings\OrganizationSettings;
use App\Settings\BrandingSettings;

$organizationSettings = app(OrganizationSettings::class);
$brandingSettings = app(BrandingSettings::class);
$orgName = $organizationSettings->name ?? 'CBT System';
$pageTitle = $title ?? "Login Portal - {$orgName}";
$faviconUrl = $brandingSettings->getFaviconUrl();
@endphp

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $pageTitle }}</title>

    @if($faviconUrl)
        <link rel="icon" type="image/png" href="{{ $faviconUrl }}">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Dynamic Branding Colors -->
    <style>
        :root {
            --color-primary: {{ $brandingSettings->primary_color }};
            --color-secondary: {{ $brandingSettings->secondary_color }};
            --color-accent: {{ $brandingSettings->accent_color }};
        }
    </style>

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="h-full bg-gradient-to-br from-gray-50 to-gray-100">
    <div class="h-full">
        {{ $slot }}
    </div>
</body>
</html>