@props(['size' => 'lg'])

@php
use App\Settings\BrandingSettings;
use App\Settings\OrganizationSettings;

$sizeClasses = [
    'sm' => 'max-h-10 max-w-10',
    'md' => 'max-h-12 max-w-12', 
    'lg' => 'max-h-20 max-w-20',
    'xl' => 'max-h-28 max-w-28'
];

$logoSize = $sizeClasses[$size] ?? $sizeClasses['lg'];

// Get dynamic branding
$brandingSettings = app(BrandingSettings::class);
$organizationSettings = app(OrganizationSettings::class);
$logoUrl = $brandingSettings->getLogoUrl();
$orgName = $organizationSettings->name ?? 'CBT System';
@endphp

@if($logoUrl)
    <img 
        src="{{ $logoUrl }}" 
        alt="{{ $orgName }} Logo"
        class="mx-auto {{ $logoSize }} w-auto h-auto object-contain"
        loading="lazy"
    />
@else
    {{-- Default placeholder when no logo is uploaded --}}
    <div class="mx-auto {{ $logoSize }} flex items-center justify-center bg-gradient-to-br from-blue-500 to-blue-600 rounded-full">
        <span class="text-white font-bold text-2xl">{{ substr($orgName, 0, 2) }}</span>
    </div>
@endif