<?php

use Spatie\LaravelSettings\Migrations\SettingsMigration;

return new class extends SettingsMigration
{
    public function up(): void
    {
        // Organization Settings
        $this->migrator->add('organization.name', config('cbt.defaults.organization.name', 'CBT System'));
        $this->migrator->add('organization.tagline', config('cbt.defaults.organization.tagline'));
        $this->migrator->add('organization.contact_email', config('cbt.defaults.organization.contact_email'));
        $this->migrator->add('organization.contact_phone', config('cbt.defaults.organization.contact_phone'));
        $this->migrator->add('organization.address', config('cbt.defaults.organization.address'));
        $this->migrator->add('organization.timezone', config('cbt.defaults.organization.timezone', 'UTC'));
        $this->migrator->add('organization.setup_completed', false);

        // Branding Settings
        $this->migrator->add('branding.logo_path', config('cbt.defaults.branding.logo_path'));
        $this->migrator->add('branding.favicon_path', config('cbt.defaults.branding.favicon_path'));
        $this->migrator->add('branding.primary_color', config('cbt.defaults.branding.primary_color', '#2563eb'));
        $this->migrator->add('branding.secondary_color', config('cbt.defaults.branding.secondary_color', '#4b5563'));
        $this->migrator->add('branding.accent_color', config('cbt.defaults.branding.accent_color', '#059669'));

        // Terminology Settings
        $this->migrator->add('terminology.primary_user_singular', config('cbt.defaults.terminology.primary_user_singular', 'Student'));
        $this->migrator->add('terminology.primary_user_plural', config('cbt.defaults.terminology.primary_user_plural', 'Students'));
        $this->migrator->add('terminology.primary_user_id_label', config('cbt.defaults.terminology.primary_user_id_label', 'Student ID'));
        $this->migrator->add('terminology.primary_user_id_field', config('cbt.defaults.terminology.primary_user_id_field', 'matriculation_number'));

        $this->migrator->add('terminology.secondary_user_singular', config('cbt.defaults.terminology.secondary_user_singular', 'Staff'));
        $this->migrator->add('terminology.secondary_user_plural', config('cbt.defaults.terminology.secondary_user_plural', 'Staff'));
        $this->migrator->add('terminology.secondary_user_id_label', config('cbt.defaults.terminology.secondary_user_id_label', 'Staff Number'));
        $this->migrator->add('terminology.secondary_user_id_field', config('cbt.defaults.terminology.secondary_user_id_field', 'staff_number'));

        $this->migrator->add('terminology.period_label', config('cbt.defaults.terminology.period_label', 'Academic Session'));
        $this->migrator->add('terminology.period_format', config('cbt.defaults.terminology.period_format', 'YYYY/YYYY'));
        $this->migrator->add('terminology.division_label', config('cbt.defaults.terminology.division_label', 'Department'));

        // Feature Settings
        $this->migrator->add('features.secondary_user_exams', config('cbt.defaults.features.secondary_user_exams', true));
        $this->migrator->add('features.practice_mode', config('cbt.defaults.features.practice_mode', false));
        $this->migrator->add('features.certificate_generation', config('cbt.defaults.features.certificate_generation', false));
        $this->migrator->add('features.result_printing', config('cbt.defaults.features.result_printing', true));
        $this->migrator->add('features.bulk_import', config('cbt.defaults.features.bulk_import', true));
        $this->migrator->add('features.api_access', config('cbt.defaults.features.api_access', false));
        $this->migrator->add('features.dark_mode', config('cbt.defaults.features.dark_mode', true));

        // Exam Settings
        $this->migrator->add('exam.default_duration_minutes', config('cbt.defaults.exam.default_duration_minutes', 60));
        $this->migrator->add('exam.default_passing_score', config('cbt.defaults.exam.default_passing_score', 50));
        $this->migrator->add('exam.allow_review', config('cbt.defaults.exam.allow_review', true));
        $this->migrator->add('exam.shuffle_questions', config('cbt.defaults.exam.shuffle_questions', true));
        $this->migrator->add('exam.shuffle_options', config('cbt.defaults.exam.shuffle_options', true));
        $this->migrator->add('exam.show_score_immediately', config('cbt.defaults.exam.show_score_immediately', true));
        $this->migrator->add('exam.max_attempts', config('cbt.defaults.exam.max_attempts', 1));
    }
};
