<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Define permissions
        $permissions = [
            // Exam Management
            'view exams',
            'create exams',
            'edit exams',
            'delete exams',
            'manage exam sessions',
            
            // Question Bank
            'view questions',
            'create questions',
            'edit questions',
            'delete questions',
            'import questions',
            
            // Exam Grading (for essay questions)
            'grade exams',
            'review grades',
            'approve grades',
            
            // Results Management
            'view all results',
            'export results',
            'publish results',
            
            // User Management
            'view students',
            'manage students',
            'view staff',
            'manage staff',
            'view applicants',
            'manage applicants',
            
            // Reports
            'view reports',
            'generate reports',
            'export reports',
            
            // System Settings
            'view settings',
            'manage settings',
        ];

        // Create permissions for staff guard
        foreach ($permissions as $permission) {
            Permission::firstOrCreate([
                'name' => $permission,
                'guard_name' => 'staff',
            ]);
        }

        // Create roles with permissions
        
        // Examiner - Full access to manage exams, questions, sessions, and results
        $examiner = Role::firstOrCreate([
            'name' => 'Examiner',
            'guard_name' => 'staff',
        ]);
        $examiner->syncPermissions($permissions); // All permissions

        $this->command->info('Roles and permissions seeded successfully!');
        $this->command->table(
            ['Role', 'Permissions Count'],
            [
                ['Examiner', $examiner->permissions->count()],
            ]
        );
    }
}
