<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_answers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exam_attempt_id')->constrained('exam_attempts')->onDelete('cascade');
            $table->foreignId('question_bank_id')->constrained('question_banks')->onDelete('cascade');
            
            // Answer data
            $table->integer('question_index'); // Position in the exam (1-based)
            $table->string('selected_answer')->nullable(); // The candidate's answer
            $table->string('correct_answer'); // Stored for reference
            $table->boolean('is_correct')->nullable(); // null if unanswered
            
            // Scoring
            $table->decimal('marks_obtained', 8, 2)->default(0);
            $table->integer('marks_possible')->default(1);
            
            // Timing
            $table->integer('time_spent_seconds')->default(0); // Time on this question
            $table->dateTime('answered_at')->nullable();
            
            // Flags
            $table->boolean('is_flagged')->default(false); // Candidate flagged for review
            $table->boolean('is_skipped')->default(true); // Initially skipped until answered
            
            $table->timestamps();
            
            $table->unique(['exam_attempt_id', 'question_bank_id']);
            $table->index(['exam_attempt_id', 'question_index']);
            $table->index('is_correct');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_answers');
    }
};
