<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('question_banks', function (Blueprint $table) {
            // Composite indexes for common query patterns
            $table->index(['is_active', 'target_audience', 'session']); // Main filtering
            $table->index(['question_type', 'is_active']); // Type filtering
            $table->index(['created_at', 'is_active']); // Recent questions
            $table->index(['marks', 'time_limit']); // Scoring queries
            $table->index(['deleted_at', 'is_active']); // Soft delete with active status
            
            // Individual indexes for bulk operations
            $table->index('created_by'); // Audit queries
            $table->index('updated_by'); // Audit queries
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('question_banks', function (Blueprint $table) {
            // Drop the performance indexes
            $table->dropIndex(['is_active', 'target_audience', 'session']);
            $table->dropIndex(['question_type', 'is_active']);
            $table->dropIndex(['created_at', 'is_active']);
            $table->dropIndex(['marks', 'time_limit']);
            $table->dropIndex(['deleted_at', 'is_active']);
            $table->dropIndex(['created_by']);
            $table->dropIndex(['updated_by']);
        });
    }
};
