<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('question_usage_stats', function (Blueprint $table) {
            $table->id();
            
            // Question reference
            $table->foreignId('question_bank_id')->constrained()->onDelete('cascade');
            
            // Usage statistics
            $table->integer('times_used')->default(0);
            $table->integer('times_correct')->default(0);
            $table->integer('times_incorrect')->default(0);
            $table->decimal('success_rate', 5, 2)->default(0); // Percentage
            $table->decimal('average_time_taken', 8, 2)->nullable(); // Average time in seconds
            
            // Last usage tracking
            $table->timestamp('last_used_at')->nullable();
            $table->timestamp('last_updated_stats')->nullable();
            
            $table->timestamps();
            
            // Performance indexes
            $table->index('question_bank_id');
            $table->index(['success_rate', 'times_used']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('question_usage_stats');
    }
};
