<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->string('full_name');
            $table->string('matriculation_number')->unique();
            $table->string('session'); // e.g., '2024/25', '2025/26'
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('email')->unique()->nullable(); // Optional email for notifications
            $table->boolean('is_active')->default(true);
            $table->rememberToken();
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['matriculation_number', 'session']);
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
