<?php

namespace Database\Factories;

use App\Models\Applicant;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Applicant>
 */
class ApplicantFactory extends Factory
{
    protected $model = Applicant::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        static $number = 1;
        
        return [
            'full_name' => fake()->name(),
            'application_number' => 'APP/' . date('Y') . '/' . str_pad($number++, 4, '0', STR_PAD_LEFT),
            'email' => fake()->unique()->safeEmail(),
            'phone' => fake()->phoneNumber(),
            'position_applied' => fake()->randomElement(['Nurse', 'Doctor', 'Pharmacist', 'Lab Technician', 'Admin Officer']),
            'department' => fake()->randomElement(['Nursing', 'Medicine', 'Pharmacy', 'Laboratory', 'Administration']),
            'password' => Hash::make('password'),
            'is_active' => true,
        ];
    }

    /**
     * Indicate that the applicant is inactive.
     */
    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }
}
