<?php

use App\Http\Middleware\CheckFeatureEnabled;
use App\Http\Middleware\EnsureSetupIsComplete;
use App\Http\Middleware\PreventBackHistory;
use App\Http\Middleware\RedirectIfAuthenticated;
use App\Http\Middleware\RedirectIfSetupComplete;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Http\Request;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Trust all proxies (required for Render, Railway, etc.)
        $middleware->trustProxies(at: '*');
        
        // Register middleware aliases
        $middleware->alias([
            'setup.complete' => EnsureSetupIsComplete::class,
            'setup.incomplete' => RedirectIfSetupComplete::class,
            'feature' => CheckFeatureEnabled::class,
            'no.cache' => PreventBackHistory::class,
            'guest.cbt' => RedirectIfAuthenticated::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
