<?php

namespace App\Settings;

use Spatie\LaravelSettings\Settings;

class OrganizationSettings extends Settings
{
    public string $name;
    public ?string $tagline;
    public ?string $contact_email;
    public ?string $contact_phone;
    public ?string $address;
    public string $timezone;
    public bool $setup_completed;

    public static function group(): string
    {
        return 'organization';
    }

    public static function encrypted(): array
    {
        return [];
    }

    /**
     * Check if the initial setup has been completed.
     */
    public function isSetupComplete(): bool
    {
        return $this->setup_completed;
    }

    /**
     * Get the organization display name with fallback.
     */
    public function getDisplayName(): string
    {
        return $this->name ?: config('cbt.defaults.organization.name');
    }
}
