<?php

namespace App\Http\Middleware;

use App\Settings\OrganizationSettings;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfSetupComplete
{
    public function __construct(
        protected OrganizationSettings $organizationSettings
    ) {}

    /**
     * Handle an incoming request.
     *
     * Redirects away from setup wizard if setup has already been completed.
     * Prevents re-running the setup wizard after initial configuration.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($this->organizationSettings->setup_completed) {
            return redirect()->route('login');
        }

        return $next($request);
    }
}
