<?php

namespace App\Filament\Widgets;

use App\Models\Exam;
use App\Models\ExamAttempt;
use App\Models\ExamSession;
use App\Models\QuestionBank;
use App\Models\Student;
use App\Models\Staff;
use App\Settings\TerminologySettings;
use App\Enums\ExamSessionStatus;
use App\Enums\ExamAttemptStatus;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class CBTStatsOverview extends StatsOverviewWidget
{
    protected static ?int $sort = 1;
    
    protected function getStats(): array
    {
        $terminology = app(TerminologySettings::class);
        
        // Get real counts
        $totalStudents = Student::count();
        $activeStudents = Student::where('is_active', true)->count();
        $totalStaff = Staff::count();
        $activeStaff = Staff::where('employment_status', 'active')->count();
        
        $totalExams = Exam::count();
        $activeExams = Exam::where('is_active', true)->count();
        
        $totalQuestions = QuestionBank::count();
        $activeQuestions = QuestionBank::where('is_active', true)->count();
        
        $totalSessions = ExamSession::count();
        $activeSessions = ExamSession::where('status', ExamSessionStatus::ACTIVE)->count();
        
        $totalAttempts = ExamAttempt::count();
        $completedAttempts = ExamAttempt::where('status', ExamAttemptStatus::COMPLETED)->count();
        $passedAttempts = ExamAttempt::where('passed', true)->count();
        
        $passRate = $completedAttempts > 0 
            ? round(($passedAttempts / $completedAttempts) * 100, 1) 
            : 0;
        
        return [
            Stat::make('Total ' . $terminology->secondary_user_plural, $totalStudents)
                ->description($activeStudents . ' active')
                ->descriptionIcon('heroicon-m-academic-cap')
                ->color('primary'),
                
            Stat::make('Total ' . $terminology->primary_user_plural, $totalStaff)
                ->description($activeStaff . ' active')
                ->descriptionIcon('heroicon-m-users')
                ->color('success'),
                
            Stat::make('Question Bank', $totalQuestions)
                ->description($activeQuestions . ' active questions')
                ->descriptionIcon('heroicon-m-question-mark-circle')
                ->color('warning'),
                
            Stat::make('Exams', $totalExams)
                ->description($activeExams . ' active, ' . $activeSessions . ' sessions live')
                ->descriptionIcon('heroicon-m-clipboard-document-list')
                ->color('info'),
                
            Stat::make('Total Attempts', $totalAttempts)
                ->description($completedAttempts . ' completed')
                ->descriptionIcon('heroicon-m-document-check')
                ->color('gray'),
                
            Stat::make('Active Sessions', $activeSessions)
                ->description($totalSessions . ' total sessions')
                ->descriptionIcon('heroicon-m-calendar-days')
                ->color($activeSessions > 0 ? 'success' : 'gray'),
        ];
    }
}
