<?php

namespace App\Filament\Resources\Staff\Schemas\Components;

use App\Settings\TerminologySettings;
use Filament\Forms\Components\Select;

class StaffTypeSelect
{
    public static function make(): Select
    {
        $terminology = app(TerminologySettings::class);
        
        return Select::make('staff_type')
            ->label($terminology->secondary_user_singular . ' Type')
            ->options([
                'senior' => 'Senior',
                'junior' => 'Junior',
            ])
            ->required()
            ->suffixIcon('heroicon-m-user-group');
    }
}