<?php

namespace App\Filament\Resources\Staff\Schemas\Components;

use App\Settings\TerminologySettings;
use Filament\Forms\Components\TextInput;

class DepartmentInput
{
    public static function make(): TextInput
    {
        $terminology = app(TerminologySettings::class);
        
        return TextInput::make('department')
            ->label($terminology->division_label)
            ->required()
            ->maxLength(255)
            ->placeholder('Enter ' . strtolower($terminology->division_label))
            ->suffixIcon('heroicon-m-building-office');
    }
}