<?php

namespace App\Filament\Resources\QuestionCategories\Pages;

use App\Filament\Resources\QuestionCategories\QuestionCategoryResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Support\Enums\Width;

class CreateQuestionCategory extends CreateRecord
{
    protected static string $resource = QuestionCategoryResource::class;

    public function getMaxContentWidth(): Width
    {
        return Width::Full;
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['created_by'] = auth()->id();
        return $data;
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
