<?php

namespace App\Filament\Resources\QuestionBanks\Schemas;

use App\Settings\TerminologySettings;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class QuestionBankInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('Question Details')
                    ->schema([
                        TextEntry::make('question_text')
                            ->label('Question')
                            ->html()
                            ->columnSpanFull(),
                        
                        Grid::make(3)
                            ->schema([
                                TextEntry::make('question_type')
                                    ->label('Type')
                                    ->badge()
                                    ->formatStateUsing(fn (string $state): string => match ($state) {
                                        'single_select' => 'Multiple Choice',
                                        'true_false' => 'True/False',
                                        default => $state,
                                    }),
                                
                                TextEntry::make('target_audience')
                                    ->label('Audience')
                                    ->badge()
                                    ->formatStateUsing(function (string $state): string {
                                        $terminology = app(TerminologySettings::class);
                                        return match ($state) {
                                            'student' => $terminology->primary_user_singular,
                                            'staff' => $terminology->secondary_user_singular,
                                            default => ucfirst($state),
                                        };
                                    }),
                                
                                IconEntry::make('is_active')
                                    ->label('Status')
                                    ->boolean(),
                            ]),
                    ])
                    ->columnSpan(2),
                
                Section::make('Classification')
                    ->schema([
                        TextEntry::make('category.name')
                            ->label('Subject')
                            ->placeholder('Not specified'),
                        
                        TextEntry::make('session')
                            ->label(fn () => app(TerminologySettings::class)->period_label)
                            ->placeholder('Not specified'),
                        
                        TextEntry::make('department')
                            ->label(fn () => app(TerminologySettings::class)->division_label)
                            ->placeholder('Not specified'),
                    ])
                    ->columnSpan(1),
                
                Section::make('Answer Information')
                    ->schema([
                        TextEntry::make('correct_answer')
                            ->label('Correct Answer')
                            ->badge()
                            ->color('success'),
                        
                        TextEntry::make('explanation')
                            ->label('Explanation')
                            ->placeholder('No explanation provided')
                            ->columnSpanFull(),
                    ])
                    ->columnSpan(2),
                
                Section::make('Settings')
                    ->schema([
                        TextEntry::make('time_limit')
                            ->label('Time Limit')
                            ->suffix(' seconds')
                            ->placeholder('No limit'),
                        
                        TextEntry::make('reference')
                            ->label('Reference')
                            ->placeholder('No reference'),
                    ])
                    ->columnSpan(1)
                    ->hidden(),
                
                Section::make('Metadata')
                    ->schema([
                        TextEntry::make('creator.name')
                            ->label('Created By')
                            ->placeholder('System'),
                        
                        TextEntry::make('created_at')
                            ->label('Created At')
                            ->dateTime(),
                        
                        TextEntry::make('updater.name')
                            ->label('Updated By')
                            ->placeholder('N/A'),
                        
                        TextEntry::make('updated_at')
                            ->label('Updated At')
                            ->dateTime(),
                        
                        TextEntry::make('import_batch_id')
                            ->label('Import Batch')
                            ->placeholder('Manual entry')
                            ->visible(fn ($record) => $record && $record->import_batch_id),
                        
                        TextEntry::make('imported_at')
                            ->label('Imported At')
                            ->dateTime()
                            ->visible(fn ($record) => $record && $record->imported_at),
                    ])
                    ->columns(2)
                    ->collapsible(),
            ])
            ->columns(3);
    }
}
