<?php

namespace App\Filament\Resources\QuestionBanks\Pages;

use App\Filament\Resources\QuestionBanks\QuestionBankResource;
use Filament\Actions\DeleteAction;
use Filament\Actions\ForceDeleteAction;
use Filament\Actions\RestoreAction;
use Filament\Actions\ViewAction;
use Filament\Resources\Pages\EditRecord;

class EditQuestionBank extends EditRecord
{
    protected static string $resource = QuestionBankResource::class;

    protected function getHeaderActions(): array
    {
        return [
            ViewAction::make(),
            DeleteAction::make(),
            ForceDeleteAction::make(),
            RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Convert options from key-value format {"a": "text"} to repeater format [["key" => "A", "text" => "text"]]
        if (isset($data['options']) && is_array($data['options'])) {
            // Check if it's the simple key-value format (not repeater format)
            $firstKey = array_key_first($data['options']);
            if ($firstKey !== null && !isset($data['options'][$firstKey]['key'])) {
                // It's key-value format, convert to repeater format
                $repeaterOptions = [];
                foreach ($data['options'] as $key => $text) {
                    $repeaterOptions[] = [
                        'key' => strtoupper($key),
                        'text' => $text ?? '',
                    ];
                }
                $data['options'] = $repeaterOptions;
            }
        }

        // Ensure correct_answer is uppercase
        if (isset($data['correct_answer'])) {
            $data['correct_answer'] = strtoupper($data['correct_answer']);
        }

        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $data['updated_by'] = auth()->id();

        // Convert options from repeater format back to key-value format for storage
        if (isset($data['options']) && is_array($data['options'])) {
            // Check if it's repeater format (has 'key' and 'text' fields)
            if (!empty($data['options']) && isset($data['options'][0]['key'])) {
                $keyValueOptions = [];
                foreach ($data['options'] as $option) {
                    if (isset($option['key']) && isset($option['text'])) {
                        $keyValueOptions[strtolower($option['key'])] = $option['text'];
                    }
                }
                $data['options'] = $keyValueOptions;
            }
        }

        // Ensure correct_answer is lowercase for storage consistency
        if (isset($data['correct_answer'])) {
            $data['correct_answer'] = strtolower($data['correct_answer']);
        }

        return $data;
    }
}
