<?php

namespace App\Filament\Resources\QuestionBanks\Pages;

use App\Filament\Resources\QuestionBanks\QuestionBankResource;
use Filament\Resources\Pages\CreateRecord;

class CreateQuestionBank extends CreateRecord
{
    protected static string $resource = QuestionBankResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['created_by'] = auth()->id();

        // Convert options from repeater format to key-value format for storage
        if (isset($data['options']) && is_array($data['options'])) {
            // Check if it's repeater format (has 'key' and 'text' fields)
            if (!empty($data['options']) && isset($data['options'][0]['key'])) {
                $keyValueOptions = [];
                foreach ($data['options'] as $option) {
                    if (isset($option['key']) && isset($option['text'])) {
                        $keyValueOptions[strtolower($option['key'])] = $option['text'];
                    }
                }
                $data['options'] = $keyValueOptions;
            }
        }

        // Ensure correct_answer is lowercase for storage consistency
        if (isset($data['correct_answer'])) {
            $data['correct_answer'] = strtolower($data['correct_answer']);
        }

        return $data;
    }
}
