<?php

namespace App\Filament\Resources\Exams\Pages;

use App\Filament\Resources\Exams\ExamResource;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;

class ViewExam extends ViewRecord
{
    protected static string $resource = ExamResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\Action::make('create_session')
                ->label('Create Session')
                ->icon('heroicon-o-calendar-days')
                ->color('success')
                ->url(fn () => route('filament.admin.resources.exam-sessions.create', ['exam_id' => $this->record->id])),
        ];
    }
}
