<?php

namespace App\Filament\Resources\ExamSessions\Pages;

use App\Enums\ExamSessionStatus;
use App\Filament\Resources\ExamSessions\ExamSessionResource;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;

class ViewExamSession extends ViewRecord
{
    protected static string $resource = ExamSessionResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\Action::make('activate')
                ->label('Activate')
                ->icon('heroicon-o-play')
                ->color('success')
                ->requiresConfirmation()
                ->visible(fn (): bool => $this->record->status === ExamSessionStatus::SCHEDULED)
                ->action(fn () => $this->record->update(['status' => ExamSessionStatus::ACTIVE])),
            Actions\Action::make('complete')
                ->label('Complete')
                ->icon('heroicon-o-check-circle')
                ->color('gray')
                ->requiresConfirmation()
                ->visible(fn (): bool => $this->record->status === ExamSessionStatus::ACTIVE)
                ->action(fn () => $this->record->update(['status' => ExamSessionStatus::COMPLETED])),
        ];
    }
}
