<?php

namespace App\Filament\Pages\Auth;

use App\Settings\BrandingSettings;
use App\Settings\OrganizationSettings;
use Filament\Auth\Pages\Login as BaseLogin;
use Illuminate\Contracts\Support\Htmlable;

class Login extends BaseLogin
{
    protected string $view = 'filament.pages.auth.login';

    public function getHeading(): string|Htmlable
    {
        return 'Admin Sign In';
    }

    public function getSubheading(): string|Htmlable|null
    {
        try {
            $orgSettings = app(OrganizationSettings::class);
            return ($orgSettings->name ?? 'CBT System') . ' - Management Portal';
        } catch (\Exception $e) {
            return 'CBT System - Management Portal';
        }
    }

    public function getAuthBackgroundUrl(): string
    {
        try {
            $brandingSettings = app(BrandingSettings::class);
            return $brandingSettings->getAuthBackgroundUrl();
        } catch (\Exception $e) {
            return asset('images/fnph-building.jpg');
        }
    }
}
