<?php

namespace App\Enums;

enum QuestionSelectionType: string
{
    case MANUAL = 'manual';
    case RANDOM = 'random';
    case CATEGORY_BASED = 'category_based';

    public function getLabel(): string
    {
        return match ($this) {
            self::MANUAL => 'Manual Selection',
            self::RANDOM => 'Random Selection',
            self::CATEGORY_BASED => 'Category-Based Distribution',
        };
    }

    public function getDescription(): string
    {
        return match ($this) {
            self::MANUAL => 'Select specific questions for this exam',
            self::RANDOM => 'Randomly select questions from the question bank',
            self::CATEGORY_BASED => 'Select questions based on category distribution',
        };
    }
}
