<?php

namespace App\Enums;

enum ExamAttemptStatus: string
{
    case IN_PROGRESS = 'in_progress';
    case COMPLETED = 'completed';
    case ABANDONED = 'abandoned';
    case TIMED_OUT = 'timed_out';

    public function getLabel(): string
    {
        return match ($this) {
            self::IN_PROGRESS => 'In Progress',
            self::COMPLETED => 'Completed',
            self::ABANDONED => 'Abandoned',
            self::TIMED_OUT => 'Timed Out',
        };
    }

    public function getColor(): string
    {
        return match ($this) {
            self::IN_PROGRESS => 'warning',
            self::COMPLETED => 'success',
            self::ABANDONED => 'gray',
            self::TIMED_OUT => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::IN_PROGRESS => 'heroicon-o-play',
            self::COMPLETED => 'heroicon-o-check-circle',
            self::ABANDONED => 'heroicon-o-x-mark',
            self::TIMED_OUT => 'heroicon-o-clock',
        };
    }
}
